/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.CrookBaseItem;

public class CrookRecipeSerializer
extends ExNihiloRecipeSerializer<CrookRecipe> {
    @Override
    @Nullable
    public ItemStack getIcon() {
        RegistryObject<CrookBaseItem> woodCrook = ExNihiloItems.CROOK_WOOD;
        if (woodCrook != null) {
            return new ItemStack((ItemLike)woodCrook.get());
        }
        return null;
    }

    @Nonnull
    public CrookRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int outputCount = buffer.readInt();
        ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            output.add(ItemStackWithChance.read(buffer));
        }
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new CrookRecipe(recipeId, input, output);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull CrookRecipe recipe) {
        buffer.writeInt(recipe.getOutput().size());
        for (ItemStackWithChance stack : recipe.getOutput()) {
            stack.write(buffer);
        }
        recipe.getInput().m_43923_(buffer);
    }

    @Override
    @Nonnull
    protected CrookRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        JsonArray results = json.getAsJsonArray("results");
        ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            output.add(ItemStackWithChance.deserialize(results.get(i)));
        }
        return new CrookRecipe(recipeId, input, output);
    }
}

